<?php
// Inicia la sesión
session_start();

// Verifica si la variable de sesión 'usuario_id' está establecida
if (isset($_SESSION['usuario_id'])) {
    // La sesión está activa, puedes acceder a las variables de sesión
    $usuarioId = $_SESSION['usuario_id'];
    $correo = $_SESSION['correo'];
    $nombres = $_SESSION['nombres'];
    $apellidos = $_SESSION['apellidos'];

    // Tu lógica aquí para usuarios autenticados

} else {
    // La sesión no está activa, redirige a la página de inicio de sesión u otra acción
    header('Location: login.php'); // Cambia 'iniciar_sesion.php' por la página de inicio de sesión
    exit(); // Asegúrate de detener la ejecución del script después de redirigir
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>NIVO| Usuarios </title>
	<link rel="shortcut icon" href="#" />

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css">
  <!-- overlayScrollbars -->
  <link rel="stylesheet" href="plugins/overlayScrollbars/css/OverlayScrollbars.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css">
    <style>
        #usuarios-container {
            margin-top: 20px;
        }

        .pagination {
            display: flex;
            list-style: none;
        }

        .pagination li {
            margin: 0 5px;
            cursor: pointer;
        }
    </style>
    <script src="plugins/jquery/jquery.min.js"></script>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<!-- Site wrapper -->
<div class="wrapper">
    <?php 
include 'includes\navbar.php';
?>

 <?php 
include 'includes\aside.php';
?>


  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Usuarios</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">inicio</a></li>
              <li class="breadcrumb-item"><a href="#">Usuarios</a></li>
              
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
    <div class="col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">Usuarios</h3>

                <div class="card-tools">
                <div class="input-group input-group-sm" style="width: 150px;">
                  <input type="text" id="inputBusqueda" class="form-control float-right" placeholder="Buscar">
                    <div class="input-group-append">
                         <button type="button" class="btn btn-default" onclick="buscar()">
                            <i class="fas fa-search"></i>
                         </button>
                    </div>
                    <div id="bot"> <input type="hidden" id="inputBusqueda2" class="form-control float-right" placeholder="Buscar"></div>
          </div>

                </div>
              </div>
              <!-- /.card-header -->
              <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Correo</th>
                      <th>Nombres</th>
                      <th>Apellidos</th>
                      <th>Rut</th>
                      <th>Perfil</th>
                      <th>Estado</th>
                      <th>Editar</th>
                      <th>Contraseña</th>
                    </tr>
                  </thead>
                  <tbody id="usuarios-container">"
                    
                 
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <div class="card-footer clearfix" id="pagination-container">
                <ul class="pagination pagination-sm m-0 float-right">
                  <li class="page-item">1</li>
                  <li class="page-item">2</li>
                  <li class="page-item"></li>
                  <li class="page-item"><a class="page-link" href="#">3</a></li>
                  <li class="page-item"><a class="page-link" href="#">»</a></li>
                </ul>
              </div>
            <!-- /.card -->
          </div>
          

	
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

<!-- Modal de Cambio Exitoso -->
<div class="modal fade" id="cambioExitosoModal" tabindex="-1" role="dialog" aria-labelledby="cambioExitosoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cambioExitosoModalLabel">Cambio Exitoso</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                ¡El cambio se realizó con éxito!
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<!-- Modal Cambiar Contraseña -->
<div class="modal fade" id="cambiarContrasenaModal" tabindex="-1" role="dialog" aria-labelledby="cambiarContrasenaModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="cambiarContrasenaModalLabel">Cambiar Contraseña</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Aquí coloca los campos necesarios para cambiar la contraseña, como nueva contraseña y confirmación -->
                 <!-- Elemento para almacenar el ID de usuario -->
                 <div id="errorMensaje" class="alert alert-danger" style="display: none;"></div>
                <input type="hidden" id="userIdModal" value="">

                <label for="nuevaContrasena">Nueva Contraseña:</label>
                <input type="password" id="nuevaContrasena" class="form-control" required>

                <label for="confirmarContrasena">Confirmar Contraseña:</label>
                <input type="password" id="confirmarContrasena" class="form-control" required>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" onclick="cambiarContrasena()">Guardar Cambios</button>
            </div>
        </div>
    </div>
</div>

 <?php 
include 'includes\footer.php';
?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- overlayScrollbars -->
<script src="plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js"></script>
<!-- AdminLTE App -->
<script src="dist/js/adminlte.min.js"></script>
<!-- AdminLTE for demo purposes -->
<script src="dist/js/demo.js"></script>
<script>
  $(document).ready(function() {
  cargarUsuarios(1); // Cargar la primera página al cargar la página

  // Manejar clics en la paginación
  $(document).on('click', '.pagination li', function() {
    var pagina = $(this).data('pagina');
    
    
    var busqueda = $('#inputBusqueda2').val();

    cargarUsuarios(pagina,busqueda);
  });

  
});
</script>
<script>
   function cargarUsuarios(pagina, busqueda = '') {
    $.ajax({
      url: 'includes/ajax_cargar_usuarios.php',
      method: 'GET',
      data: {pagina: pagina, busqueda: busqueda},
      success: function(data) {

        $('#usuarios-container').html(data.usuarios);
        $('#pagination-container').html(data.paginacion);
      }
    });
  }
    function buscar() {
    var busqueda = $('#inputBusqueda').val();
    $('#bot').html("<input type='hidden' id='inputBusqueda2' class='form-control float-right' value = '"+busqueda+"'>");
    cargarUsuarios(1, busqueda);
  }
  $(document).on('change', '.chk-estado', function() {
    var idUsuario = $(this).data('id');
    var nuevoEstado = $(this).prop('checked') ? 1 : 0;
    console.log(idUsuario+" - "+nuevoEstado)
    cambiarEstadoUsuario(idUsuario, nuevoEstado);
  });

  function cambiarEstadoUsuario(idUsuario, nuevoEstado) {
    // Realizar la solicitud AJAX para cambiar el estado del usuario
 
    $.ajax({
      url: 'includes/ajax_cambiar_estado_usuario.php',
      method: 'GET',
      data: {idUsuario: idUsuario, nuevoEstado: nuevoEstado},
      success: function(data) {
        console.log(data);
        if (data.success) {
          console.log('Estado cambiado correctamente.');
          $('#cambioExitosoModal').modal('show');
          
        } else {
          // Manejar errores si es necesario
          console.error('Error al cambiar el estado del usuario.');
        }
      }
    });
    
  }
$(document).on('click', '.btn-cambiar-contrasena', function() {
        var idUsuario = $(this).data('id');
        $('#userIdModal').val(idUsuario);
        // Oculta el mensaje de error en el modal
        var errorMensaje = $('#errorMensaje');
          errorMensaje.hide();
          document.getElementById('nuevaContrasena').value = '';
            document.getElementById('confirmarContrasena').value = '';
        abrirModalCambioContrasena(idUsuario);
    });
    function abrirModalCambioContrasena(idUsuario) {
        // Puedes realizar acciones adicionales aquí si es necesario
        $('#cambiarContrasenaModal').modal('show');
    }
    function cambiarContrasena() {
    // Accede al ID de usuario almacenado en el modal
   
    var idUsuario = $('#userIdModal').val();
    //console.log('Cambiar contraseña para el usuario con ID:', idUsuario);

    var nuevaContrasena = $('#nuevaContrasena').val();

    // Accede al elemento de mensaje de error en el modal
    var errorMensaje = $('#errorMensaje');
    // Validar que la contraseña tenga al menos 6 caracteres
    if (nuevaContrasena.length < 6) {
        // Muestra el mensaje de error en el modal
        errorMensaje.text('La contraseña debe tener al menos 6 caracteres.').show();
        return;
    }
    // Continúa con la operación de cambio de contraseña...
    //console.log('Cambiar contraseña para el usuario con ID:', idUsuario, 'Nueva Contraseña:', nuevaContrasena);
    $.ajax({
      url: 'includes/ajax_cambiar_contrasena.php',
      method: 'GET',
      data: {idUsuario: idUsuario, nuevaContrasena: nuevaContrasena},
      success: function(data) {
        console.log(data);
        if (data.success) {
          console.log('contraseña cambiada correctamente.');
          $('#cambioExitosoModal').modal('show');
          
        } else {
          // Manejar errores si es necesario
          console.error('Error al cambiar el estado del usuario.');
        }
      }
    });

    // Oculta el mensaje de error en el modal
    errorMensaje.hide();

    // Oculta el modal
    $('#cambiarContrasenaModal').modal('hide');
}

</script>
</body>
</html>
