<?php
include 'db.php';

// Función para obtener todos los usuarios (activos e inactivos)
function obtenerUsuarios() {
    global $conn;
    $query = "SELECT * FROM usuarios";
    $result = mysqli_query($conn, $query);
    return $result;
}

// Función para obtener un usuario por su ID
function obtenerUsuarioPorID($idUsuario) {
    global $conn;
    $query = "SELECT * FROM usuarios WHERE id_usuario=$idUsuario";
    $result = mysqli_query($conn, $query);
    return mysqli_fetch_assoc($result);
}

// Función para agregar un nuevo usuario
function agregarUsuario($correo, $nombres, $apellidos, $rut, $idPerfil, $clave) {
    global $conn;
    $query = "INSERT INTO usuarios (correo, nombres, apellidos, rut, id_perfil, clave, activo) VALUES ('$correo', '$nombres', '$apellidos', '$rut', $idPerfil, '$clave', 1)";
    return mysqli_query($conn, $query);
}

// Función para editar un usuario existente
function editarUsuario($idUsuario, $correo, $nombres, $apellidos, $rut, $idPerfil, $clave, $activo) {
    global $conn;
    // Verificar si se proporcionó una nueva contraseña
    $passwordUpdate = $clave ? ", clave='$clave'" : "";
    $query = "UPDATE usuarios SET correo='$correo', nombres='$nombres', apellidos='$apellidos', rut='$rut', id_perfil=$idPerfil $passwordUpdate, activo=$activo WHERE id_usuario=$idUsuario";
    return mysqli_query($conn, $query);
}


// Función para activar  o desactivar un usuario
function activaUsuario($idUsuario,$estado) {
    global $conn;
    $idUsuario=$idUsuario;
   
    $query = "UPDATE usuarios SET activo=$estado WHERE id_usuario=$idUsuario";
  
    return mysqli_query($conn, $query);
}

// Función para cambiar la contraseña de un usuario
function cambiarClaveUsuario($idUsuario, $nuevaClave) {
    global $conn;
    // Puedes agregar aquí lógica adicional, como validar la fortaleza de la nueva contraseña, etc.
    $query = "UPDATE usuarios SET clave='$nuevaClave' WHERE id_usuario=$idUsuario";
    return mysqli_query($conn, $query);
}

// Función para obtener una lista paginada de usuarios
function obtenerUsuariosPaginados($inicio, $limite, $busqueda = "") {
    global $conn;

    $where = "";
    if (!empty($busqueda)) {
        $where = " WHERE u.correo LIKE '%$busqueda%' OR 
                          u.nombres LIKE '%$busqueda%' OR 
                          u.apellidos LIKE '%$busqueda%' OR 
                          u.rut LIKE '%$busqueda%' OR 
                          p.perfil LIKE '%$busqueda%'";
    }

    $query = "SELECT u.*, p.perfil
              FROM usuarios u
              LEFT JOIN perfiles p ON u.id_perfil = p.id_perfil
              $where
              LIMIT $inicio, $limite";

    $result = mysqli_query($conn, $query);

    return mysqli_fetch_all($result, MYSQLI_ASSOC);
}


// Función para obtener el número total de usuarios
function obtenerTotalUsuarios($busqueda = "") {
    global $conn;
    $where = "";
    if (!empty($busqueda)) {
        $where = " WHERE u.correo LIKE '%$busqueda%' OR 
                          u.nombres LIKE '%$busqueda%' OR 
                          u.apellidos LIKE '%$busqueda%' OR 
                          u.rut LIKE '%$busqueda%' OR 
                          p.perfil LIKE '%$busqueda%'";
    }
    $query = "SELECT COUNT(*) as total
    FROM usuarios u
    LEFT JOIN perfiles p ON u.id_perfil = p.id_perfil ".$where;
     
    
    $result = mysqli_query($conn, $query);
    $row = mysqli_fetch_assoc($result);
    return $row['total'];
}

?>
