<?php
header('Content-Type: application/json'); // Asegura que la respuesta sea JSON

include('encripta.php');
session_start(); // Asegura que la sesión esté iniciada
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    include_once 'db.php';

    $camposVacios = array();
    foreach ($_POST as $key => $value) {
        if (empty($value)) {
            $camposVacios[] = $key;
        }
    }

    if (!empty($camposVacios)) {
        $message = "Los siguientes campos están vacíos: " . implode(", ", $camposVacios);
        $response = array('success' => false, 'message' => $message);
        echo json_encode($response);
        exit;
    }

    $codigo = $_POST['codigo'];
    $codigo = desencriptarId($codigo);

    // Recuperar los valores actuales del producto desde la base de datos
    $sql = "SELECT * FROM Productos WHERE codigo = '$codigo'";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        $currentData = $result->fetch_assoc();
    } else {
        $response = array('success' => false, 'message' => 'Producto no encontrado');
        echo json_encode($response);
        exit;
    }

    // Construir la consulta para actualizar los datos
    $sql = "UPDATE Productos SET ";
    $changes = array(); // Variable para almacenar los cambios realizados
    foreach ($_POST as $key => $value) {
        // Evitar actualizar los campos 'id' y 'codigo', ya que 'codigo' es la clave primaria
        if ($key !== 'id' && $key !== 'codigo' && $value != $currentData[$key]) {
            $sql .= "$key = '$value', ";
            $changes[] = "$key: " . $currentData[$key] . " -> " . $value; // Registrar el cambio
        }
    }
    $sql = rtrim($sql, ", ");
    $sql .= " WHERE codigo = '$codigo'";

    // Verificar si hay cambios
    if (empty($changes)) {
        $response = array('success' => false, 'message' => 'No se realizaron cambios');
        echo json_encode($response);
        exit;
    }

    // Ejecutar la consulta
    if ($conn->query($sql) === TRUE) {
        // Registrar los cambios en la tabla Historial
        $usuario = $_SESSION['usuario_id'];
        //$cambios = $_SESSION['nombres'] .' '. $_SESSION['apellidos'].' actualiza : '.implode(", ", $changes);
        $cambios = 'Actualiza datos : '.implode(", ", $changes);
        $modulo = 'Inventario';
        $historialSql = "INSERT INTO Historial (codigo, cambios, usuario, modulo) VALUES ('$codigo', '$cambios', '$usuario', '$modulo')";

        if ($conn->query($historialSql) === TRUE) {
            $response = array(
                'success' => true, 
                'message' => 'Producto actualizado exitosamente', 
                'changes' => $changes
            );
        } else {
            $response = array('success' => false, 'message' => 'Error al registrar el historial: ' . $conn->error);
        }
    } else {
        $response = array('success' => false, 'message' => 'Error al actualizar el producto: ' . $conn->error);
    }

    $conn->close();
    echo json_encode($response);
} else {
    $response = array('success' => false, 'message' => 'La solicitud no es POST');
    echo json_encode($response);
}
?>
