<?php
// Archivo: obtener_tipos.php

// Incluir el archivo de conexión a la base de datos
include('db.php');

// Consulta SQL para obtener las categorías
$sql = "SELECT documento_id, tipo_documento FROM Documentos";

// Ejecutar la consulta
$resultado = $conn->query($sql);

// Verificar si hay filas de resultado
if ($resultado->num_rows > 0) {
    // Crear un array para almacenar las categorías
    $categorias = array();
    // Iterar sobre los resultados y agregar cada categoría al array
    while ($fila = $resultado->fetch_assoc()) {
        $categorias[] = array(
            'id' => $fila['documento_id'],
            'descripcion' => utf8_encode($fila['tipo_documento'])
        );
      
    }
    // Devolver los datos en formato JSON
    echo json_encode($categorias);
   
} else {
    // Si no hay categorías, devolver un array vacío
    echo json_encode(array());
}

// Cerrar la conexión a la base de datos
$conn->close();
?>
