<?php
// Archivo: obtener_tipos.php

// Incluir el archivo de conexión a la base de datos
include('db.php');

// Consulta SQL para obtener las materiales
$sql = "SELECT color_id, descripcion FROM Colores";

// Ejecutar la consulta
$resultado = $conn->query($sql);

// Verificar si hay filas de resultado
if ($resultado->num_rows > 0) {
    // Crear un array para almacenar las materiales
    $categorias = array();
    // Iterar sobre los resultados y agregar cada estilo al array
    while ($fila = $resultado->fetch_assoc()) {
        $categorias[] = array(
            'id' => $fila['color_id'],
            'descripcion' => utf8_encode($fila['descripcion'])
        );
      
    }
    // Devolver los datos en formato JSON
    echo json_encode($categorias);
   
} else {
    // Si no hay materiales, devolver un array vacío
    echo json_encode(array());
}

// Cerrar la conexión a la base de datos
$conn->close();
?>
